"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClientController = void 0;
const common_1 = require("@nestjs/common");
const prisma_service_1 = require("../prisma.service");
const client_dto_1 = require("./client.dto");
const dayjs = require("dayjs");
const auth_guard_1 = require("../guards/auth/auth.guard");
let ClientController = class ClientController {
    constructor(prismaService) {
        this.prismaService = prismaService;
    }
    async paginate(page, term) {
        const pageTake = 10;
        const queryCount = await this.prismaService.client.count({
            where: {
                name: {
                    contains: term
                }
            },
        });
        const queryData = await this.prismaService.client.findMany({
            where: {
                name: {
                    contains: term,
                }
            },
            orderBy: {
                created_at: 'desc'
            },
            include: {
                user_client: true,
                user_pic: true,
                schedule: true,
                detail_kegiatan: true,
                keuangan: true
            },
            take: pageTake,
            skip: (page - 1) * pageTake
        });
        return {
            data: queryData,
            paginate: {
                per_page: pageTake,
                total_page: Math.round((queryCount / pageTake) + 0.4),
                count: queryCount,
                current_page: page
            }
        };
    }
    async create(body) {
        const queryFindFirstUser = await this.prismaService.user.findFirst({
            where: {
                username: body.username
            }
        });
        if (queryFindFirstUser) {
            return {
                success: false,
                message: `Username Sudah Terdaftar, Mohon untuk Menggunakan Username yang lain.`
            };
        }
        else {
            const queryCreateUser = await this.prismaService.user.create({
                data: {
                    username: body.username,
                    password: body.password,
                    full_name: body.name,
                    phone_number: body.phone_number,
                    role: "CLIENT",
                    address: body.address,
                    created_at: dayjs().add(8, 'hour').toDate(),
                    updated_at: dayjs().add(8, 'hour').toDate()
                }
            });
            const queryCreateClient = await this.prismaService.client.create({
                data: {
                    lokasi_acara: body.lokasi_acara,
                    name: body.name,
                    address: body.address,
                    phone_number: body.phone_number,
                    jenis_acara: body.jenis_acara,
                    tanggal_acara: dayjs(body.tanggal_acara).add(8, 'hour').toDate(),
                    waktu_acara: body.waktu_acara,
                    user_client_id: queryCreateUser.id,
                    user_pic_id: body.user_pic_id,
                    created_at: dayjs().add(8, 'hour').toDate(),
                    updated_at: dayjs().add(8, 'hour').toDate()
                }
            });
            await this.prismaService.schedule.create({
                data: {
                    group_wa: 0,
                    pengiriman_form: 0,
                    rab_invoice: 0,
                    mou: 0,
                    kua: 0,
                    hastag: 0,
                    layout: 0,
                    update_catatan: 0,
                    client_id: queryCreateClient.id,
                    created_at: dayjs().add(8, 'hour').toDate()
                }
            });
            await this.prismaService.keuangan.create({
                data: {
                    nilai_kontrak: 0,
                    dp_client: 0,
                    hutang_client: 0,
                    anggaran_kegiatan: 0,
                    vendor_terbayar: 0,
                    vendor_belum_terbayar: 0,
                    uang_balejanur_terpakai: 0,
                    sisa_uang: 0,
                    pure_profit: 0,
                    client_id: queryCreateClient.id,
                    created_at: dayjs().add(8, 'hour').toDate()
                }
            });
            return {
                success: true,
                message: `Data Client Berhasil Ditambahkan.`
            };
        }
    }
    async update(id, body) {
        const queryFindFirst = await this.prismaService.client.findUnique({
            where: {
                id: Number(id)
            }
        });
        await this.prismaService.user.update({
            data: {
                username: body.username,
                password: body.password
            },
            where: {
                id: queryFindFirst.user_client_id
            }
        });
        await this.prismaService.client.update({
            data: {
                lokasi_acara: body.lokasi_acara,
                name: body.name,
                address: body.address,
                phone_number: body.phone_number,
                jenis_acara: body.jenis_acara,
                tanggal_acara: dayjs(body.tanggal_acara).add(8, 'hour').toDate(),
                waktu_acara: body.waktu_acara,
                user_pic_id: body.user_pic_id,
                updated_at: dayjs().add(8, 'hour').toDate()
            },
            where: {
                id: Number(id)
            }
        });
        return {
            success: true,
            message: `Data Client Berhasil Diupdate.`
        };
    }
    async softDelete(id) {
        await this.prismaService.client.update({
            data: {
                deleted_status: 1
            },
            where: {
                id: id
            }
        });
        return {
            success: true,
            message: `Data Client Berhasil Dihapus Sementara.`
        };
    }
};
exports.ClientController = ClientController;
__decorate([
    (0, common_1.Post)("search-paginate"),
    __param(0, (0, common_1.Body)("page")),
    __param(1, (0, common_1.Body)("term")),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, String]),
    __metadata("design:returntype", Promise)
], ClientController.prototype, "paginate", null);
__decorate([
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [client_dto_1.ClientCreateDto]),
    __metadata("design:returntype", Promise)
], ClientController.prototype, "create", null);
__decorate([
    (0, common_1.Put)(":id"),
    __param(0, (0, common_1.Param)("id")),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, client_dto_1.ClientUpdateDto]),
    __metadata("design:returntype", Promise)
], ClientController.prototype, "update", null);
__decorate([
    (0, common_1.Post)("soft-delete"),
    __param(0, (0, common_1.Body)("id")),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", Promise)
], ClientController.prototype, "softDelete", null);
exports.ClientController = ClientController = __decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Controller)('client'),
    __metadata("design:paramtypes", [prisma_service_1.PrismaService])
], ClientController);
//# sourceMappingURL=client.controller.js.map