import { Paginate } from './../interface/paginate';
import { Client } from '@prisma/client';
import { PrismaService } from 'src/prisma.service';
import { ClientCreateDto, ClientUpdateDto } from './client.dto';
import { ResponseMessage } from 'src/interface/response-message';
interface EventTicketPaginate {
    data: Client[];
    paginate: Paginate;
}
export declare class ClientController {
    private prismaService;
    constructor(prismaService: PrismaService);
    paginate(page: number, term: string): Promise<EventTicketPaginate>;
    create(body: ClientCreateDto): Promise<ResponseMessage>;
    update(id: string, body: ClientUpdateDto): Promise<ResponseMessage>;
    softDelete(id: number): Promise<ResponseMessage>;
}
export {};
